//+------------------------------------------------------------------+
//|                                                        Pivot.mq4 |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2004, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"

#property indicator_chart_window

extern bool ManualCalculation = false;
extern double LastWeek_high = 0;
extern double LastWeek_low  = 0;
extern double LastWeek_close = 0;

double P=0;
double Q=0;
double H8,H7,H6,H5,H4,H3,L3,L4,L5,L6,L7,L8;
double nQ=0;
double nD=0;
double D=0;
double rates_d1[2][6];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
 H8=0; H7=0; H6=0; H5=0; H4=0; H3=0; L3=0; L4=0; L5=0; L6=0; L7=0; L8=0;

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- TODO: add your code here

ObjectDelete("WP Label");
ObjectDelete("WP Line");

ObjectDelete("WH8 Label");
ObjectDelete("WH8 Line");
ObjectDelete("WH7 Label");
ObjectDelete("WH7 Line");
ObjectDelete("WH6 Label");
ObjectDelete("WH6 Line");
ObjectDelete("WH5 Label");
ObjectDelete("WH5 Line");
ObjectDelete("WH4 Label");
ObjectDelete("WH4 Line");
ObjectDelete("WH3 Label");
ObjectDelete("WH3 Line");
ObjectDelete("WL3 Label");
ObjectDelete("WL3 Line");
ObjectDelete("WL4 Label");
ObjectDelete("WL4 Line");
ObjectDelete("WL5 Label");
ObjectDelete("WL5 Line");
ObjectDelete("WL6 Label");
ObjectDelete("WL6 Line");
ObjectDelete("WL7 Label");
ObjectDelete("WL7 Line");
ObjectDelete("WL8 Label");
ObjectDelete("WL8 Line");

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {

//---- TODO: add your code here

//---- exit if period is greater than daily charts
if(Period() > 1440)
{
Print("Error - Chart period is greater than 1 day.");
return(-1); // then exit
}

//---- Get new daily prices

ArrayCopyRates(rates_d1, Symbol(), PERIOD_W1);
if ( ManualCalculation == false)
{
LastWeek_close = rates_d1[1][4];
LastWeek_high = rates_d1[1][3];
LastWeek_low = rates_d1[1][2];
}



//---- Calculate Pivots

Q = (LastWeek_high - LastWeek_low);
P = (LastWeek_high + LastWeek_low + LastWeek_close) / 3;


	H8 = (Q*1.62)+LastWeek_close;
	H7 = (Q*1.35)+LastWeek_close;
	H6 = (Q*1.09)+LastWeek_close;
	H5 = (Q*0.82)+LastWeek_close;
	H4 = (Q*0.55)+LastWeek_close;
   H3 = (Q*0.27)+LastWeek_close;
   L3 = LastWeek_close-(Q*0.27);
	L4 = LastWeek_close-(Q*0.55);
	L5 = LastWeek_close-(Q*0.82);	
	L6 = LastWeek_close-(Q*1.09);
	L7 = LastWeek_close-(Q*1.35);
	L8 = LastWeek_close-(Q*1.62);
	

if (Q > 5) 
{
	nQ = Q;
}
else
{
	nQ = Q*10000;
}

if (D > 5)
{
	nD = D;
}
else
{
	nD = D*10000;
}


Comment("High= ",LastWeek_high,"    Previous Days Range= ",nQ,"\nLow= ",LastWeek_low,"    Current Days Range= ",nD,"\nClose= ",LastWeek_close);

//---- Set line labels on chart window

//---- Pivot Lines


      if(ObjectFind("WP label") != 0)
      {
      ObjectCreate("WP label", OBJ_TEXT, 0, Time[0], P);
      ObjectSetText("WP label", "Weekly Pivot", 9, "Arial", Yellow);
      }
      else
      {
      ObjectMove("WP label", 0, Time[0], P);
      }


//---  Draw  Pivot lines on chart


      if(ObjectFind("WP line") != 0)
      {
      ObjectCreate("WP line", OBJ_HLINE, 0, Time[40], P);
      ObjectSet("WP line", OBJPROP_STYLE, STYLE_DASH);
      ObjectSet("WP line", OBJPROP_WIDTH, 0);
      ObjectSet("WP line", OBJPROP_COLOR, Yellow);
      }
      else
      {
      ObjectMove("WP line", 0, Time[40], P);
      }



      if(ObjectFind("WH8 label") != 0)
      {
      ObjectCreate("WH8 label", OBJ_TEXT, 0, Time[10], H8);
      ObjectSetText("WH8 label", "Weekly H8 Ex Overbought", 9, "Arial", Yellow);
      }
      else
      {
      ObjectMove("WH8 label", 0, Time[10], H8);
      }
      
      if(ObjectFind("WH7 label") != 0)
      {
      ObjectCreate("WH7 label", OBJ_TEXT, 0, Time[10], H7);
      ObjectSetText("WH7 label", "Weekly H7 Overbought", 9, "Arial", Yellow);
      }
      else
      {
      ObjectMove("WH7 label", 0, Time[10], H7);
      }
      
      
      if(ObjectFind("WH6 label") != 0)
      {
      ObjectCreate("WH6 label", OBJ_TEXT, 0, Time[10], H6);
      ObjectSetText("WH6 label", "Weekly H6", 9, "Arial", Aqua);
      }
      else
      {
      ObjectMove("WH6 label", 0, Time[10], H6);
      }

      if(ObjectFind("WH5 label") != 0)
      {
      ObjectCreate("WH5 label", OBJ_TEXT, 0, Time[10], H5);
      ObjectSetText("WH5 label", "Weekly H5", 9, "Arial", Lime);
      }
      else
      {
      ObjectMove("WH5 label", 0, Time[10], H5);
      }


      if(ObjectFind("WH4 label") != 0)
      {
      ObjectCreate("WH4 label", OBJ_TEXT, 0, Time[10], H4);
      ObjectSetText("WH4 label", "Weekly H4", 9, "Arial", Lime);
      }
      else
      {
      ObjectMove("WH4 label", 0, Time[10], H4);
      }


      if(ObjectFind("WH3 label") != 0)
      {
      ObjectCreate("WH3 label", OBJ_TEXT, 0, Time[10], H3);
      ObjectSetText("WH3 label", "Weekly H3", 9, "Arial", Magenta);
      }
      else
      {
      ObjectMove("WH3 label", 0, Time[10], H3);
      }



      if(ObjectFind("WL3 label") != 0)
      {
      ObjectCreate("WL3 label", OBJ_TEXT, 0, Time[10], L3);
      ObjectSetText("WL3 label", "Weekly L3", 9, "Arial", Magenta);
      }
      else
      {
      ObjectMove("WL3 label", 0, Time[10], L3);
      }



      if(ObjectFind("WL4 label") != 0)
      {
      ObjectCreate("WL4 label", OBJ_TEXT, 0, Time[10], L4);
      ObjectSetText("WL4 label", "Weekly L4", 9, "Arial", Red);
      }
      else
      {
      ObjectMove("WL4 label", 0, Time[10], L4);
      }

      if(ObjectFind("WL5 label") != 0)
      {
      ObjectCreate("WL5 label", OBJ_TEXT, 0, Time[10], L5);
      ObjectSetText("WL5 label", "Weekly L5", 9, "Arial", Red);
      }
      else
      {
      ObjectMove("WL5 label", 0, Time[10], L5);
      }

      if(ObjectFind("WL6 label") != 0)
      {
      ObjectCreate("WL6 label", OBJ_TEXT, 0, Time[10], L6);
      ObjectSetText("WL6 label", "Weekly L6", 9, "Arial", Aqua);
      }
      else
      {
      ObjectMove("WL6 label", 0, Time[10], L6);
      }
      
      if(ObjectFind("WL7 label") != 0)
      {
      ObjectCreate("WL7 label", OBJ_TEXT, 0, Time[10], L7);
      ObjectSetText("WL7 label", "Weekly L7 Oversold", 9, "Arial", Yellow);
      }
      else
      {
      ObjectMove("WL7 label", 0, Time[10], L7);
      }
      
      if(ObjectFind("WL8 label") != 0)
      {
      ObjectCreate("WL8 label", OBJ_TEXT, 0, Time[10], L8);
      ObjectSetText("WL8 label", "Weekly L8 Ex Oversold", 9, "Arial", Yellow);
      }
      else
      {
      ObjectMove("WL8 label", 0, Time[10], L8);
      }

//---- Draw Camarilla lines on Chart
     if(ObjectFind("WH8 line") != 0)
      {
      ObjectCreate("WH8 line", OBJ_HLINE, 0, Time[40], H8);
      ObjectSet("WH8 line", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("WH8 line", OBJPROP_WIDTH, 3);
      ObjectSet("WH8 line", OBJPROP_COLOR, Yellow);
      }
      else
      {
      ObjectMove("WH8 line", 0, Time[40], H8);
      }
      
      if(ObjectFind("WH7 line") != 0)
      {
      ObjectCreate("WH7 line", OBJ_HLINE, 0, Time[40], H7);
      ObjectSet("WH7 line", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("WH7 line", OBJPROP_WIDTH, 3);
      ObjectSet("WH7 line", OBJPROP_COLOR, Yellow);
      }
      else
      {
      ObjectMove("WH7 line", 0, Time[40], H7);
      }
     
      if(ObjectFind("WH6 line") != 0)
      {
      ObjectCreate("WH6 line", OBJ_HLINE, 0, Time[40], H6);
      ObjectSet("WH6 line", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("WH6 line", OBJPROP_WIDTH, 3);
      ObjectSet("WH6 line", OBJPROP_COLOR, Aqua);
      }
      else
      {
      ObjectMove("WH6 line", 0, Time[40], H6);
      }

      if(ObjectFind("WH5 line") != 0)
      {
      ObjectCreate("WH5 line", OBJ_HLINE, 0, Time[40], H5);
      ObjectSet("WH5 line", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("WH5 line", OBJPROP_WIDTH, 2);
      ObjectSet("WH5 line", OBJPROP_COLOR, Lime);
      }
      else
      {
      ObjectMove("WH5 line", 0, Time[40], H5);
      }
      
      
      
      if(ObjectFind("WH4 line") != 0)
      {
      ObjectCreate("WH4 line", OBJ_HLINE, 0, Time[40], H4);
      ObjectSet("WH4 line", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("WH4 line", OBJPROP_WIDTH, 2);
      ObjectSet("WH4 line", OBJPROP_COLOR, Lime);
      }
      else
      {
      ObjectMove("WH4 line", 0, Time[40], H4);
      }


      if(ObjectFind("WH3 line") != 0)
      {
      ObjectCreate("WH3 line", OBJ_HLINE, 0, Time[40], H3);
      ObjectSet("WH3 line", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("WH3 line", OBJPROP_WIDTH, 3);
      ObjectSet("WH3 line", OBJPROP_COLOR, Magenta);
      }
      else
      {
      ObjectMove("WH3 line", 0, Time[40], H3);
      }


      if(ObjectFind("WL3 line") != 0)
      {
      ObjectCreate("WL3 line", OBJ_HLINE, 0, Time[40], L3);
      ObjectSet("WL3 line", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("WL3 line", OBJPROP_WIDTH, 3);
      ObjectSet("WL3 line", OBJPROP_COLOR, Magenta);
      }
      else
      {
      ObjectMove("WL3 line", 0, Time[40], L3);
      }


      if(ObjectFind("WL4 line") != 0)
      {
      ObjectCreate("WL4 line", OBJ_HLINE, 0, Time[40], L4);
      ObjectSet("WL4 line", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("WL4 line", OBJPROP_WIDTH, 2);
      ObjectSet("WL4 line", OBJPROP_COLOR, Red);
      }
      else
      {
      ObjectMove("WL4 line", 0, Time[40], L4);
      }

      if(ObjectFind("WL5 line") != 0)
      {
      ObjectCreate("WL5 line", OBJ_HLINE, 0, Time[40], L5);
      ObjectSet("WL5 line", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("WL5 line", OBJPROP_WIDTH, 2);
      ObjectSet("WL5 line", OBJPROP_COLOR, Red);
      
      }
      else
      {
      ObjectMove("WL5 line", 0, Time[40], L5);
      }

      if(ObjectFind("WL6 line") != 0)
      {
      ObjectCreate("WL6 line", OBJ_HLINE, 0, Time[40], L6);
      ObjectSet("WL6 line", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("WL6 line", OBJPROP_WIDTH, 3);
      ObjectSet("WL6 line", OBJPROP_COLOR, Aqua);
      }
      else
      {
      ObjectMove("WL6 line", 0, Time[40], L6);
      }
      
      if(ObjectFind("WL7 line") != 0)
      {
      ObjectCreate("WL7 line", OBJ_HLINE, 0, Time[40], L7);
      ObjectSet("WL7 line", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("WL7 line", OBJPROP_WIDTH, 3);
      ObjectSet("WL7 line", OBJPROP_COLOR, Yellow);
      }
      else
      {
      ObjectMove("WL7 line", 0, Time[40], L7);
      }
      
      if(ObjectFind("WL8 line") != 0)
      {
      ObjectCreate("WL8 line", OBJ_HLINE, 0, Time[40], L8);
      ObjectSet("WL8 line", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("WL8 line", OBJPROP_WIDTH, 3);
      ObjectSet("WL8 line", OBJPROP_COLOR, Yellow);
      }
      else
      {
      ObjectMove("WL8 line", 0, Time[40], L8);
      }


 
//---- End Of Program
   return(0);
  }
//+------------------------------------------------------------------+